----------------------------------------------------------------------------
--ArmyArrived Event
----------------------------------------------------------------------------
--
--
function eventArmyArrived(player, mission)
	--
	local log_id = C_THINK_LOG
	local squad_num = checkPlayerSquad(player)
	--
	if ( squad_num ~= -1 ) then
		--
		log(log_id, player, "HAS ARRIVED AT:", string.upper(SQUADS_DESTINATIONS[player]))
		--
		local destination = SQUADS_DESTINATIONS[player]
		--
		setDestination(squad_num, "")
		stopTime()
		--
		local retreat_sector = nil
		
		if ( SQUAD_RETREAT_POSITIONS ~= nil ) then
		
			retreat_sector = SQUAD_RETREAT_POSITIONS[player]	
		
		end
		
		--log("global_map", "retreat sector = ["..retreat_sector.."]")
		
		local hide_dd = function()
			if (false==checkIfAnySquadIsInSector("drug_deal")) then
				if ((retreat_sector == "drug_deal") and (destination ~= "drug_deal" )) then
					if ( getGVAR("PI_DRUG_DEAL_DONE") == _YES ) then
						if ( Sectors["drug_deal"].enabled == true ) then
							Sectors["drug_deal"].enabled = false
						end
					end
				end
			end
		end
		
		if ( belongsToEnemy(destination) ) then
			
			
			if ( messageBox("attack_sector", YES_NO, SMALL) == NO ) then
				
				if ( retreat_sector == nil ) then

					if( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
						sound2D("ui/misc/helicopter_stop")
					else
						sound2D("ui/misc/car_stop")
					end

					log("global_map","BAD sector to retreat")
					--
					SQUAD_IS_MOVING[player] = false
					--
					setPosition(squad_num, destination)
					enterSector(destination)
									--
					hide_dd()
					--
				else
					setDestination(squad_num, retreat_sector)

					if( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
						sound2D("ui/misc/helicopter_start")
					else
						sound2D("ui/misc/car_start")
					end

					startArmyMovement(player, destination, retreat_sector, "move", Joints[destination][retreat_sector].path,  Joints[destination][retreat_sector].distance, true)
					--SQUAD_IS_MOVING[player] = false
				end
			else
				--
				if( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
					sound2D("ui/misc/helicopter_stop")
				else
					sound2D("ui/misc/car_stop")
				end
				--
				SQUAD_IS_MOVING[player] = false
				--
				setPosition(squad_num, destination)
				enterSector(destination)
				--
				hide_dd()
				--
			end
			
		else
			messageBox(player.."_arrived", OK, SMALL)
			--
			SQUAD_IS_MOVING[player] = false
			--
			setPosition(squad_num, destination)
			--
			if ( (destination ~= "north_road") and (destination ~= "drug_deal") and (DEBUG == false) ) then
				discoverSectors(destination)
			end
			
			hide_dd()
			if( (Sectors["airport"].owner == CURRENT_ALLY) or (GVARS.Cheats == 1) ) then
				sound2D("ui/misc/helicopter_stop")
			else
				sound2D("ui/misc/car_stop")
			end
		end
	else
		if ( mission == "enemy_attack" ) then
			--
			log("_strategy_", "AUTOBATTLE 1")
			--
			local suffix_len = (string.len(player) - string.len("figure_"))
			local player_name = string.sub(player, -suffix_len)
			local sector = ENEMY_DESTINATIONS[player_name]
			local defender = Sectors[sector].owner
			local d_num = 0
			--
			log("_strategy_", "Player:", player_name, "Sector:", sector, "Defender:", defender)			
			--
			ATTACKER_SIDE = player_name
			DEFENDER_SIDE = defender
			CONTESTED_SECTOR = sector
			--
			log("_strategy_", "AUTOBATTLE 2")
			--
			for count = 1, 4, 1 do
				local mt, mc = getMilitia(sector, count)
				if ( isValid(mc) and isValid(mt) ) then
					d_num = d_num + mc
				end
			end
			--
			local force_size = 5 * GAME_STAGE + 5 * DIFFICULTY
			--
			if ( force_size > 20 ) then
				force_size = 20
			elseif ( force_size == 0 ) then
				force_size = 5
			end
			--
			if ( Pool[player_name].current >= force_size ) then
				Pool[player_name].current = Pool[player_name].current - force_size
			else
				force_size = Pool[player_name].current
				Pool[player_name].current = 0
			end
			--
			STRATEGY_DATA[player_name].Moving = false
			--
			if ( Sectors[CONTESTED_SECTOR].owner == CURRENT_ALLY ) then
				if ( checkIfAnySquadIsInSector(CONTESTED_SECTOR) == false ) then
					stopTime()
					sound2D("ui/misc/combat_started_02")
					startAutoBattle(CONTESTED_SECTOR, ATTACKER_SIDE, DEFENDER_SIDE, force_size, d_num)
				else
					stopTime()
					showMessageBox("enemy_attacks", OK, SMALL)
					--
					BATTLE_DATA.Attacker = ATTACKER_SIDE
					BATTLE_DATA.AttackerSize = force_size
					BATTLE_DATA.Sector = CONTESTED_SECTOR
					BATTLE_DATA.Enabled = true
					--
					activateSpawn(BATTLE_DATA.Sector, PLAYER, "defence", true)
					
					local getMercs = function(index, merc)
						if ( merc ~= nil ) then
							log("squad", merc, getMercSquad(merc))
							local squad = tonumber(getMercSquad(merc))
							local pos = SQUADS_POSITIONS["squad"..squad]
							
							log("squad", merc, squad, pos, " battle:", BATTLE_DATA.Sector)
							
							if ( pos == BATTLE_DATA.Sector ) then
								table.insert(CUR_MISSION.Mercs, merc)
							end
						end
					end
					
					--local hmercs = getHiredMercs(true)
					
					table.foreach(HIRED_MERCS, getMercs)
					
					enterSector(sector, false)
				end
			else
				local on = force_size
				local dn = d_num
				local winner = ATTACKER_SIDE
				local winner_n = force_size
				
				for count = 1, force_size, 1 do
					local res = CampaignScript.onAutoBattleUpdate(CONTESTED_SECTOR, ATTACKER_SIDE, DEFENDER_SIDE, on, dn, true)
				
					if ( res == ATTACKER_SIDE ) then
						on = on - 1
					else
						dn = dn - 1
					end

					if (on <= 0) or (dn <= 0) then
						winner_n = on
						break
					end
				end
				
				if ( on < dn ) then
					winner = DEFENDER_SIDE
					winner_n = dn
				end
				
				CampaignScript.onAutoBattleEnd(winner, winner_n)
			end
			--
		end
	end
	--
	return
	--
end
--
--
--
--
--